function stop = optimIterPlotSin(x, optimValues, state)
    switch state
        case 'iter'
              updatePlot(x)
              stop = false;
        case 'interrupt'
              stop = true;
        case 'init'
              firstPlot(x)
              stop = false;
        case 'done'
            hold off
            stop = true;
    otherwise
    end
    
    
    
    function firstPlot(x)
        figure;
        myAx = gca;
        my_x = linspace(-20,20,100);
        my_y = 5*sin(my_x)+0.1*my_x.^2;
        plot(my_x,my_y)
        hold on
        y = 5*sin(x)+0.1*x.^2;
        scatter(myAx,x,y,'filled','d','r')
    end

    function updatePlot(x)
        myAx = gca;
        hold on
        y = 5*sin(x)+0.1*x.^2;
        scatter(myAx,x,y,'filled','d','r')
    end
end



